//
//  B5Category.h
//  ApplicationFrameworks
//
//  Created by Rick Fillion on 2015-05-11.
//
//

#import "B5DatabaseObject.h"
#import <OnePasswordDataModel/OnePasswordDataModel.h>

@interface B5Category : B5DatabaseObject <OPGenericCategory, NSSecureCoding>

// OPGenericCategory
@property (nonatomic, copy) NSString *uuid;
@property (nonatomic, copy) NSString *singularName;
@property (nonatomic, copy) NSString *pluralName;
@property (nonatomic, copy) NSString *actionName;
@property (readonly, getter = isSystemCategory) BOOL systemCategory;
@property (readonly, getter = isPremiumCategory) BOOL premiumCategory;
@property (nonatomic, copy) NSString *detailIconName; // Main icon name to download, should be resized to anything other than source
@property (nonatomic, copy) NSString *sourceIconName; // Secondary icon name for B5
@property (nonatomic) NSUInteger numberOfItems;

@property (nonatomic) BOOL hasCustomIcon;
@property (nonatomic, strong) OPImage * customIcon;

@property (nonatomic, readonly, getter = isHidden) BOOL hidden;

// B5Category Specific
@property (nonatomic, copy) NSDictionary *jsonDictionary;
@property (nonatomic, assign) OPID accountId;

+ (instancetype) categoryWithTemplate:(OPTemplate *)aTemplate existingId:(OPID)oid accountId:(OPID)accountId jsonDictionary:(NSDictionary *)jsonDictionary;
- (instancetype)initAdHocWithUUID:(NSString *)uuid;

@end

@interface B5Category (Private)

@end